/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.ComplexVoltage;
import app.SingleShot;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import util.Logger;

public class Sample {
    static Logger logger = Logger.getLogger();
    private double target;
    private double freq;
    public List<SingleShot> entries = new ArrayList<SingleShot>();

    public double getFreq() {
        return this.freq;
    }

    public double getTarget() {
        return this.target;
    }

    public Sample(double t, double f) {
        this.target = t;
        this.freq = f;
    }

    public void addShot(SingleShot shot) {
        this.entries.add(shot);
    }

    public double getSigAzi(boolean b) {
        if (b) {
            return this.getSigAzi();
        }
        return this.getCplAzi();
    }

    private double getSigAzi() {
        Iterator<SingleShot> it = this.entries.iterator();
        double result = 0.0;
        int n = 0;
        double corr360 = 0.0;
        while (it.hasNext()) {
            SingleShot shot = it.next();
            if (!shot.getCategory().equals("s")) continue;
            corr360 = shot.getAzi();
            if (corr360 - this.target > 270.0) {
                corr360 -= 360.0;
            }
            if (corr360 - this.target < -270.0) {
                corr360 += 360.0;
            }
            result += corr360;
            ++n;
        }
        if (n > 0) {
            result /= (double)n;
        }
        return result;
    }

    private double getCplAzi() {
        Iterator<SingleShot> it = this.entries.iterator();
        double result = 0.0;
        int n = 0;
        double corr360 = 0.0;
        while (it.hasNext()) {
            SingleShot shot = it.next();
            if (!shot.getCategory().equals("s")) continue;
            ComplexVoltage cvt = new ComplexVoltage(shot.getRealX(), shot.getRealY(), shot.getImagX(), shot.getImagY());
            corr360 = cvt.getAzi(this.target);
            if (corr360 - this.target > 270.0) {
                corr360 -= 360.0;
            }
            if (corr360 - this.target < -270.0) {
                corr360 += 360.0;
            }
            result += corr360;
            ++n;
        }
        if (n > 0) {
            result /= (double)n;
        }
        return result;
    }
}

